﻿//////////////////////////////////////////////
// RenderQueueManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "RenderQueue.h"

#include "../Utils/Manager.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT RenderQueueManager final : public Manager<RenderQueue>, public nkCommon::MaybeSingletonClass<RenderQueueManager>
	{
		public :

			// Constants
			inline static const nkMemory::StringView DEFAULT_RENDER_QUEUE = "NILKINS_DEFAULT_RENDER_QUEUE" ;

		private :

			RenderQueueManager (bool isSingleton) noexcept ;
			RenderQueueManager (System* system) noexcept ;

		private :

			friend class nkCommon::MaybeSingletonClass<RenderQueueManager> ;
			friend class System ;
	} ;
}